/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.tileentities.tiered;

import com.github.bartimaeusnek.bartworks.API.BioVatLogicAdder;
import com.github.bartimaeusnek.bartworks.API.IRadMaterial;
import com.github.bartimaeusnek.bartworks.API.LoaderReference;
import com.github.bartimaeusnek.bartworks.client.gui.GT_GUIContainer_RadioHatch;
import com.github.bartimaeusnek.bartworks.server.container.GT_Container_RadioHatch;
import com.github.bartimaeusnek.bartworks.util.BW_ColorUtil;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.MathUtils;
import com.github.bartimaeusnek.crossmod.GTpp.loader.RadioHatchCompat;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class GT_MetaTileEntity_RadioHatch
extends GT_MetaTileEntity_Hatch {
    private final int cap;
    public int sievert;
    private long timer = 1L;
    private short[] colorForGUI;
    private byte mass;
    private String material;
    private byte coverage;

    public GT_MetaTileEntity_RadioHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{StatCollector.translateToLocal((String)"tooltip.tile.radhatch.0.name"), StatCollector.translateToLocal((String)"tooltip.tile.tiereddsc.3.name") + " " + (aTier - 2) + " " + (aTier - 2 >= 2 ? StatCollector.translateToLocal((String)"tooltip.bw.kg.1.name") : StatCollector.translateToLocal((String)"tooltip.bw.kg.0.name")), StatCollector.translateToLocal((String)"tooltip.tile.radhatch.1.name"), StatCollector.translateToLocal((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks"}, new ITexture[0]);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public GT_MetaTileEntity_RadioHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
        this.cap = aTier - 2;
    }

    public static long calcDecayTicks(int x) {
        long ret = x == 43 ? 5000L : (x == 61 ? 4500L : (x <= 100 ? (long)MathUtils.ceil((8000.0 * Math.tanh((double)(-x) / 20.0) + 8000.0) * 1000.0) : (long)MathUtils.ceil(8000.0 * Math.tanh((double)(-x) / 65.0) + 8000.0)));
        return ret;
    }

    public int getSievert() {
        return this.sievert - (int)MathUtils.ceil((float)this.sievert / 100.0f * (float)this.coverage);
    }

    public short[] getColorForGUI() {
        if (this.colorForGUI != null) {
            return this.colorForGUI;
        }
        return new short[]{250, 250, 255};
    }

    public byte getMass() {
        return this.mass;
    }

    public byte getCoverage() {
        return this.coverage;
    }

    public void setCoverage(short coverage) {
        int nu = coverage > 100 ? 100 : (coverage < 0 ? 0 : (int)((byte)coverage));
        this.coverage = (byte)nu;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_IN)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new GT_MetaTileEntity_RadioHatch(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aPlayer.openGui((Object)"bartworks", 2, this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public void updateSlots() {
        if (this.mInventory[0] != null && this.mInventory[0].stackSize <= 0) {
            this.mInventory[0] = null;
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            Materials materials;
            OrePrefixes orePrefixes;
            ItemStack lStack;
            if (this.mass > 0) {
                ++this.timer;
            }
            if (this.mass > 0 && this.sievert > 0 && GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) > 0L && this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) == 0L) {
                this.mass = (byte)(this.mass - 1);
                if (this.mass == 0) {
                    this.material = StatCollector.translateToLocal((String)"tooltip.bw.empty.name");
                    this.sievert = 0;
                }
                this.timer = 1L;
            }
            if ((lStack = this.mInventory[0]) == null) {
                return;
            }
            IRadMaterial radmat = null;
            if (LoaderReference.miscutils) {
                radmat = RadioHatchCompat.GTppRadChecker(lStack);
            }
            if (lStack.getItem() instanceof IRadMaterial || radmat != null) {
                int sv;
                if (radmat == null) {
                    radmat = (IRadMaterial)lStack.getItem();
                }
                if ((sv = radmat.getRadiationLevel(lStack)) > BioVatLogicAdder.RadioHatch.getMaxSv()) {
                    BioVatLogicAdder.RadioHatch.MaxSV = sv;
                }
                if ((this.mass == 0 || this.sievert == sv) && this.mass + radmat.getAmountOfMaterial(lStack) <= this.cap) {
                    this.mass = (byte)(this.mass + radmat.getAmountOfMaterial(lStack));
                    this.sievert = sv;
                    --this.mInventory[0].stackSize;
                    this.updateSlots();
                    this.colorForGUI = radmat.getColorForGUI(lStack);
                    this.material = radmat.getNameForGUI(lStack);
                    return;
                }
            }
            if (GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_4.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_4.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Uraniumcell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Uraniumcell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Uraniumcell_4.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_4.get(1L, new Object[0]))) {
                Materials materials2 = Materials.Uranium;
                int kg = 3;
                if (GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_4.get(1L, new Object[0]))) {
                    materials2 = Materials.Plutonium;
                } else if (GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_4.get(1L, new Object[0]))) {
                    materials2 = Materials.Thorium;
                } else if (GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_1.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_4.get(1L, new Object[0]))) {
                    materials2 = Materials.Naquadah;
                } else {
                    kg = 6;
                }
                if (GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Uraniumcell_2.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_2.get(1L, new Object[0]))) {
                    kg = (byte)(2 * kg);
                } else if (GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Moxcell_4.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.Uraniumcell_4.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.ThoriumCell_4.get(1L, new Object[0])) || GT_Utility.areStacksEqual((ItemStack)lStack, (ItemStack)ItemList.NaquadahCell_4.get(1L, new Object[0]))) {
                    kg = (byte)(4 * kg);
                }
                if ((this.mass == 0 || this.sievert == BW_Util.calculateSv(materials2)) && this.mass + kg <= this.cap) {
                    this.sievert = BW_Util.calculateSv(materials2);
                    this.mass = (byte)(this.mass + kg);
                    --this.mInventory[0].stackSize;
                    this.updateSlots();
                    this.colorForGUI = materials2.mColor.mRGBa;
                    this.material = materials2.mName;
                }
            }
            for (ItemStack varStack : BioVatLogicAdder.RadioHatch.getIsSv().keySet()) {
                if (!GT_Utility.areStacksEqual((ItemStack)varStack, (ItemStack)lStack) || this.mass != 0 && this.sievert != BioVatLogicAdder.RadioHatch.getIsSv().get(varStack) || this.mass >= this.cap) continue;
                this.mass = (byte)(this.mass + 1);
                this.sievert = BioVatLogicAdder.RadioHatch.getIsSv().get(varStack);
                --this.mInventory[0].stackSize;
                this.updateSlots();
                this.colorForGUI = null;
                this.material = StatCollector.translateToLocal((String)varStack.getUnlocalizedName());
                return;
            }
            if (GT_OreDictUnificator.getAssociation((ItemStack)lStack) != null && GT_OreDictUnificator.getAssociation((ItemStack)lStack).mMaterial != null && GT_OreDictUnificator.getAssociation((ItemStack)lStack).mMaterial.mMaterial != null && GT_OreDictUnificator.getAssociation((ItemStack)lStack).mPrefix != null && ((orePrefixes = GT_OreDictUnificator.getAssociation((ItemStack)lStack).mPrefix).equals((Object)OrePrefixes.stickLong) || orePrefixes.equals((Object)OrePrefixes.stick)) && ((materials = GT_OreDictUnificator.getAssociation((ItemStack)lStack).mMaterial.mMaterial).getProtons() >= 83L && materials.getProtons() != 125L || materials.getProtons() == 61L || materials.getProtons() == 43L) && (this.mass == 0 || this.sievert == BW_Util.calculateSv(materials)) && this.mass + (orePrefixes.equals((Object)OrePrefixes.stickLong) ? 2 : 1) <= this.cap) {
                this.sievert = BW_Util.calculateSv(materials);
                this.mass = (byte)(this.mass + (orePrefixes.equals((Object)OrePrefixes.stickLong) ? 2 : 1));
                --this.mInventory[0].stackSize;
                this.updateSlots();
                this.colorForGUI = materials.mColor.mRGBa;
                this.material = materials.mName;
            }
        }
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        if (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) != 0L) {
            return new String[]{StatCollector.translateToLocal((String)"tooltip.tile.radhatch.2.name") + " " + this.material, StatCollector.translateToLocal((String)"tooltip.tile.radhatch.3.name") + " " + this.sievert, StatCollector.translateToLocal((String)"tooltip.tile.radhatch.4.name") + " " + this.mass, StatCollector.translateToLocal((String)"tooltip.tile.radhatch.5.name") + " " + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) * 60L)) + StatCollector.translateToLocal((String)"tooltip.tile.radhatch.6.name") + "/" + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert)) / 20L + StatCollector.translateToLocal((String)"tooltip.tile.radhatch.7.name") + "/" + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert)) / 20L / 60L + StatCollector.translateToLocal((String)"tooltip.tile.radhatch.8.name") + "/" + (GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert) - this.timer % GT_MetaTileEntity_RadioHatch.calcDecayTicks(this.sievert)) / 20L / 60L / 60L + StatCollector.translateToLocal((String)"tooltip.tile.radhatch.9.name")};
        }
        return new String[]{StatCollector.translateToLocal((String)"tooltip.tile.radhatch.2.name") + " " + StatCollector.translateToLocal((String)"tooltip.bw.empty.name"), StatCollector.translateToLocal((String)"tooltip.tile.radhatch.3.name") + " 0", StatCollector.translateToLocal((String)"tooltip.tile.radhatch.4.name") + " 0"};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_RadioHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_RadioHatch(aPlayerInventory, aBaseMetaTileEntity, this.mName);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.setByte("mMass", this.mass);
        aNBT.setByte("mSv", (byte)(this.sievert - 100));
        aNBT.setByte("mCoverage", this.coverage);
        aNBT.setInteger("mTextColor", BW_ColorUtil.getColorFromRGBArray(this.getColorForGUI()));
        if (this.material != null && !this.material.isEmpty()) {
            aNBT.setString("mMaterial", this.material);
        }
        aNBT.setLong("timer", this.timer);
        super.saveNBTData(aNBT);
    }

    public long getTimer() {
        return this.timer;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.timer = aNBT.getLong("timer");
        this.mass = aNBT.getByte("mMass");
        this.sievert = aNBT.getByte("mSv") + 100;
        this.coverage = aNBT.getByte("mCoverage");
        this.colorForGUI = BW_ColorUtil.splitColorToRBGArray(aNBT.getInteger("mTextColor"));
        this.material = aNBT.getString("mMaterial");
        super.loadNBTData(aNBT);
    }
}

